
<?php
/**
 * InnogreenSites - Equipment object (inverters, modules)
 */
require_once DOL_DOCUMENT_ROOT.'/core/class/commonobject.class.php';

class IgtEquipment extends CommonObject
{
    public $element = 'igt_equipment';
    public $table_element = 'igt_equipment';

    public $id;
    public $entity;
    public $fk_soc;
    public $fk_contact;
    public $equip_type;          // INVERTER | MODULE
    public $equip_identifier;    // user-defined identifier (text)
    public $manufacturer;
    public $model;

    // Inverter fields
    public $pac_w;               // AC power (W)

    // Module fields
    public $pmp_w;
    public $voc_v;
    public $isc_a;

    public $note;

    public function __construct($db)
    {
        $this->db = $db;
    }

    public function create($user, $notrigger = 0)
    {
        global $conf;

        $this->entity = (int) $this->entity;
        if (empty($this->entity)) $this->entity = (int) $conf->entity;

        $sql = "INSERT INTO ".MAIN_DB_PREFIX."igt_equipment(".
            "entity,fk_soc,fk_contact,equip_type,equip_identifier,manufacturer,model,".
            "pac_w,pmp_w,voc_v,isc_a,note,datec,tms,fk_user_creat".
            ") VALUES (".
            (int)$this->entity.",".
            (int)$this->fk_soc.",".
            (int)$this->fk_contact.",".
            "'".$this->db->escape($this->equip_type)."',".
            ($this->equip_identifier !== null && $this->equip_identifier !== '' ? "'".$this->db->escape($this->equip_identifier)."'" : "NULL").",".
            ($this->manufacturer !== null && $this->manufacturer !== '' ? "'".$this->db->escape($this->manufacturer)."'" : "NULL").",".
            ($this->model !== null && $this->model !== '' ? "'".$this->db->escape($this->model)."'" : "NULL").",".
            ($this->pac_w !== null ? (int)$this->pac_w : "NULL").",".
            ($this->pmp_w !== null ? (int)$this->pmp_w : "NULL").",".
            ($this->voc_v !== null ? (float)$this->voc_v : "NULL").",".
            ($this->isc_a !== null ? (float)$this->isc_a : "NULL").",".
            ($this->note !== null && $this->note !== '' ? "'".$this->db->escape($this->note)."'" : "NULL").",".
            "'".$this->db->idate(dol_now())."',".
            "'".$this->db->idate(dol_now())."',".
            (int)$user->id.
            ")";

        $this->db->begin();

        $res = $this->db->query($sql);
        if (!$res) {
            $this->error = $this->db->lasterror();
            $this->db->rollback();
            return -1;
        }

        $this->id = $this->db->last_insert_id(MAIN_DB_PREFIX."igt_equipment");

        $this->db->commit();
        return $this->id;
    }

    public function update($user, $notrigger = 0)
    {
        global $conf;

        $this->entity = (int) $this->entity;
        if (empty($this->entity)) $this->entity = (int) $conf->entity;

        $sql = "UPDATE ".MAIN_DB_PREFIX."igt_equipment SET ".
            "equip_identifier=".($this->equip_identifier !== null && $this->equip_identifier !== '' ? "'".$this->db->escape($this->equip_identifier)."'" : "NULL").",".
            "manufacturer=".($this->manufacturer !== null && $this->manufacturer !== '' ? "'".$this->db->escape($this->manufacturer)."'" : "NULL").",".
            "model=".($this->model !== null && $this->model !== '' ? "'".$this->db->escape($this->model)."'" : "NULL").",".
            "pac_w=".($this->pac_w !== null ? (int)$this->pac_w : "NULL").",".
            "pmp_w=".($this->pmp_w !== null ? (int)$this->pmp_w : "NULL").",".
            "voc_v=".($this->voc_v !== null ? (float)$this->voc_v : "NULL").",".
            "isc_a=".($this->isc_a !== null ? (float)$this->isc_a : "NULL").",".
            "note=".($this->note !== null && $this->note !== '' ? "'".$this->db->escape($this->note)."'" : "NULL").",".
            "tms='".$this->db->idate(dol_now())."' ".
            "WHERE rowid=".(int)$this->id." AND entity=".(int)$this->entity;

        $this->db->begin();
        $res = $this->db->query($sql);
        if (!$res) {
            $this->error = $this->db->lasterror();
            $this->db->rollback();
            return -1;
        }
        $this->db->commit();
        return 1;
    }

    public function delete($user, $notrigger = 0)
    {
        global $conf;

        $entity = (int) $conf->entity;

        $this->db->begin();

        $sql = "DELETE FROM ".MAIN_DB_PREFIX."igt_string WHERE entity=".$entity." AND fk_inverter_eq=".(int)$this->id;
        $res = $this->db->query($sql);
        if (!$res) {
            $this->error = $this->db->lasterror();
            $this->db->rollback();
            return -1;
        }

        $sql = "DELETE FROM ".MAIN_DB_PREFIX."igt_equipment WHERE rowid=".(int)$this->id." AND entity=".$entity;
        $res = $this->db->query($sql);
        if (!$res) {
            $this->error = $this->db->lasterror();
            $this->db->rollback();
            return -1;
        }

        $this->db->commit();
        return 1;
    }

    public static function fetchAllByType($db, $entity, $socid, $contactid, $type)
    {
        $out = [];
        $sql = "SELECT rowid, entity, fk_soc, fk_contact, equip_type, equip_identifier, manufacturer, model, pac_w, pmp_w, voc_v, isc_a, note, datec, tms
                FROM ".MAIN_DB_PREFIX."igt_equipment
                WHERE entity=".(int)$entity."
                  AND fk_soc=".(int)$socid."
                  AND fk_contact=".(int)$contactid."
                  AND equip_type='".$db->escape($type)."'
                ORDER BY rowid DESC";
        $res = $db->query($sql);
        if ($res) {
            while ($obj = $db->fetch_object($res)) {
                $out[] = (array) $obj;
            }
        }
        return $out;
    }

    public static function fetchOne($db, $entity, $id)
    {
        $sql = "SELECT rowid, entity, fk_soc, fk_contact, equip_type, equip_identifier, manufacturer, model, pac_w, pmp_w, voc_v, isc_a, note
                FROM ".MAIN_DB_PREFIX."igt_equipment
                WHERE entity=".(int)$entity." AND rowid=".(int)$id;
        $res = $db->query($sql);
        if ($res && ($obj = $db->fetch_object($res))) return (array) $obj;
        return null;
    }
}
