
<?php
/**
 * InnogreenSites - PV strings object
 */
require_once DOL_DOCUMENT_ROOT.'/core/class/commonobject.class.php';

class IgtString extends CommonObject
{
    public $element = 'igt_string';
    public $table_element = 'igt_string';

    public $id;
    public $entity;
    public $fk_soc;
    public $fk_contact;

    public $string_identifier;     // user-defined identifier (text)
    public $fk_inverter_eq;        // equipment rowid (inverter)
    public $mppt_no;
    public $string_no;

    public $modules_in_series;
    public $strings_in_parallel;

    public $voc_string_v;
    public $isc_string_a;

    public $note;

    public function __construct($db)
    {
        $this->db = $db;
    }

    public function create($user, $notrigger = 0)
    {
        global $conf;

        $this->entity = (int)$this->entity;
        if (empty($this->entity)) $this->entity = (int)$conf->entity;

        $sql = "INSERT INTO ".MAIN_DB_PREFIX."igt_string(".
            "entity,fk_soc,fk_contact,string_identifier,fk_inverter_eq,mppt_no,string_no,modules_in_series,strings_in_parallel,voc_string_v,isc_string_a,note,datec,tms,fk_user_creat".
            ") VALUES (".
            (int)$this->entity.",".
            (int)$this->fk_soc.",".
            (int)$this->fk_contact.",".
            ($this->string_identifier !== null && $this->string_identifier !== '' ? "'".$this->db->escape($this->string_identifier)."'" : "NULL").",".
            (int)$this->fk_inverter_eq.",".
            ($this->mppt_no !== null ? (int)$this->mppt_no : "NULL").",".
            ($this->string_no !== null ? (int)$this->string_no : "NULL").",".
            ($this->modules_in_series !== null ? (int)$this->modules_in_series : "NULL").",".
            ($this->strings_in_parallel !== null ? (int)$this->strings_in_parallel : "NULL").",".
            ($this->voc_string_v !== null ? (float)$this->voc_string_v : "NULL").",".
            ($this->isc_string_a !== null ? (float)$this->isc_string_a : "NULL").",".
            ($this->note !== null && $this->note !== '' ? "'".$this->db->escape($this->note)."'" : "NULL").",".
            "'".$this->db->idate(dol_now())."',".
            "'".$this->db->idate(dol_now())."',".
            (int)$user->id.
            ")";

        $this->db->begin();
        $res = $this->db->query($sql);
        if (!$res) {
            $this->error = $this->db->lasterror();
            $this->db->rollback();
            return -1;
        }
        $this->id = $this->db->last_insert_id(MAIN_DB_PREFIX."igt_string");
        $this->db->commit();
        return $this->id;
    }

    public function update($user, $notrigger = 0)
    {
        global $conf;
        $entity = (int)$conf->entity;

        $sql = "UPDATE ".MAIN_DB_PREFIX."igt_string SET ".
            "string_identifier=".($this->string_identifier !== null && $this->string_identifier !== '' ? "'".$this->db->escape($this->string_identifier)."'" : "NULL").",".
            "fk_inverter_eq=".(int)$this->fk_inverter_eq.",".
            "mppt_no=".($this->mppt_no !== null ? (int)$this->mppt_no : "NULL").",".
            "string_no=".($this->string_no !== null ? (int)$this->string_no : "NULL").",".
            "modules_in_series=".($this->modules_in_series !== null ? (int)$this->modules_in_series : "NULL").",".
            "strings_in_parallel=".($this->strings_in_parallel !== null ? (int)$this->strings_in_parallel : "NULL").",".
            "voc_string_v=".($this->voc_string_v !== null ? (float)$this->voc_string_v : "NULL").",".
            "isc_string_a=".($this->isc_string_a !== null ? (float)$this->isc_string_a : "NULL").",".
            "note=".($this->note !== null && $this->note !== '' ? "'".$this->db->escape($this->note)."'" : "NULL").",".
            "tms='".$this->db->idate(dol_now())."' ".
            "WHERE rowid=".(int)$this->id." AND entity=".$entity;

        $this->db->begin();
        $res = $this->db->query($sql);
        if (!$res) {
            $this->error = $this->db->lasterror();
            $this->db->rollback();
            return -1;
        }
        $this->db->commit();
        return 1;
    }

    public function delete($user, $notrigger = 0)
    {
        global $conf;
        $entity = (int)$conf->entity;

        $this->db->begin();
        $sql = "DELETE FROM ".MAIN_DB_PREFIX."igt_string WHERE rowid=".(int)$this->id." AND entity=".$entity;
        $res = $this->db->query($sql);
        if (!$res) {
            $this->error = $this->db->lasterror();
            $this->db->rollback();
            return -1;
        }
        $this->db->commit();
        return 1;
    }

    public static function fetchAll($db, $entity, $socid, $contactid)
    {
        $out = [];
        $sql = "SELECT s.rowid, s.string_identifier, s.fk_inverter_eq, s.mppt_no, s.string_no,
                       s.modules_in_series, s.strings_in_parallel, s.voc_string_v, s.isc_string_a, s.note,
                       e.equip_identifier as inverter_identifier, e.manufacturer as inverter_manufacturer, e.model as inverter_model
                FROM ".MAIN_DB_PREFIX."igt_string s
                LEFT JOIN ".MAIN_DB_PREFIX."igt_equipment e ON (e.rowid = s.fk_inverter_eq AND e.entity = s.entity)
                WHERE s.entity=".(int)$entity."
                  AND s.fk_soc=".(int)$socid."
                  AND s.fk_contact=".(int)$contactid."
                ORDER BY s.rowid DESC";
        $res = $db->query($sql);
        if ($res) {
            while ($obj = $db->fetch_object($res)) {
                $out[] = (array) $obj;
            }
        }
        return $out;
    }

    public static function fetchOne($db, $entity, $id)
    {
        $sql = "SELECT rowid, entity, fk_soc, fk_contact, string_identifier, fk_inverter_eq, mppt_no, string_no, modules_in_series,
                       strings_in_parallel, voc_string_v, isc_string_a, note
                FROM ".MAIN_DB_PREFIX."igt_string
                WHERE entity=".(int)$entity." AND rowid=".(int)$id;
        $res = $db->query($sql);
        if ($res && ($obj = $db->fetch_object($res))) return (array) $obj;
        return null;
    }
}
