
<?php
/**
 * Library helpers for InnogreenSites
 */

function innogreensites_get_sites($db, $socid)
{
    global $conf;

    $sites = [];

    // Contact extrafield used as "is site"
    // We store sites as contacts of the thirdparty (socid) with extrafield 'is_site' = 1
    $sql = "SELECT c.rowid as id,
                   CONCAT_WS(' ', c.firstname, c.lastname) as label
            FROM ".MAIN_DB_PREFIX."socpeople as c
            LEFT JOIN ".MAIN_DB_PREFIX."socpeople_extrafields as ex ON ex.fk_object = c.rowid
            WHERE c.fk_soc = ".(int)$socid."
              AND c.entity IN (0,".(int)$conf->entity.")
              AND ex.is_site = 1
            ORDER BY c.rowid DESC";

    $res = $db->query($sql);
    if ($res) {
        while ($obj = $db->fetch_object($res)) {
            $id = (int)$obj->id;
            $label = trim($obj->label);
            if ($id <= 0) continue;
            if ($label === '') $label = 'Site #'.$id;
            $sites[] = ['id' => $id, 'label' => $label];
        }
    }

    return $sites;
}

function innogreensites_get_site_info($db, $socid, $contactid)
{
    global $conf;

	$sql = "SELECT rowid, fk_soc, fk_contact, pdl, grid_type, pose_mode, install_type, gps, peak_power_w, photo_file
            FROM ".MAIN_DB_PREFIX."igt_site
            WHERE entity=".(int)$conf->entity."
              AND fk_soc=".(int)$socid."
              AND fk_contact=".(int)$contactid."
            LIMIT 1";
    $res = $db->query($sql);
    if ($res && ($obj = $db->fetch_object($res))) {
        return (array) $obj;
    }
    return null;
}

function innogreensites_document_relpath_for_photo($socid, $contactid, $ext='jpg')
{
    return 'sites/'.(int)$socid.'/'.(int)$contactid.'/photo.'.preg_replace('/[^a-z0-9]/i','', $ext);
}

function innogreensites_get_photo_url($relpath)
{
    if (empty($relpath)) return '';
    // document.php expects slashes as-is in the "file" parameter
    $encoded = rawurlencode($relpath);
    $encoded = str_replace('%2F', '/', $encoded);
    return DOL_URL_ROOT.'/document.php?modulepart=innogreensites&file='.$encoded;
}
