<?php
// Main UI page (no core modification): manage PV sites (as contacts) + site info + equipment + strings + batteries
// URL: /custom/innogreensites/site_card.php?socid=XX

require '../../main.inc.php';

require_once DOL_DOCUMENT_ROOT.'/contact/class/contact.class.php';
require_once DOL_DOCUMENT_ROOT.'/societe/class/societe.class.php';
require_once __DIR__.'/class/igtequipment.class.php';
require_once __DIR__.'/class/igtstring.class.php';
require_once __DIR__.'/lib/innogreensites.lib.php';

global $db, $user, $langs, $conf;

if (!$user->hasRight('innogreensites', 'read')) accessforbidden();

$langs->load('innogreensites@innogreensites');

$socid     = (int) GETPOST('socid', 'int');
$contactid = (int) GETPOST('contactid', 'int');
$action    = GETPOST('action', 'aZ09');
$id        = (int) GETPOST('id', 'int');

if ($socid <= 0) accessforbidden('Missing socid');

// Load thirdparty for display
$soc = new Societe($db);
$soc->fetch($socid);
$thirdpartyName = (!empty($soc->name) ? $soc->name : (!empty($soc->nom) ? $soc->nom : 'Tiers '.$socid));

$now = dol_now();

// Helpers
function igt_check_token()
{
    return (GETPOST('token', 'alpha') === $_SESSION['newtoken']);
}

function igt_redirect_self($socid, $contactid)
{
    header('Location: '.$_SERVER['PHP_SELF'].'?socid='.(int)$socid.($contactid ? '&contactid='.(int)$contactid : ''));
    exit;
}

// -----------------------------------------------------------------------------
// ACTIONS
// -----------------------------------------------------------------------------
if ($user->hasRight('innogreensites', 'write')) {

    // Create a new site (creates a CONTACT flagged as site + creates empty llx_igt_site row)
    if ($action === 'create_site' && igt_check_token()) {
        $sitename = trim(GETPOST('site_name', 'alphanohtml'));
        if ($sitename === '') {
            setEventMessages($langs->trans('ErrorFieldRequired', $langs->trans('SiteName')), null, 'errors');
        } else {
            $c = new Contact($db);
            $c->fk_soc = $socid;
            $c->lastname = $sitename;
            $c->firstname = '';
            $c->statut = 1;
            $res = $c->create($user);

            if ($res > 0) {
                // Ensure extrafield is_site=1
                // Note: extrafield must exist in Dolibarr (you said it already exists)
                $sql = "INSERT INTO ".MAIN_DB_PREFIX."socpeople_extrafields(fk_object, is_site, entity)
                        VALUES (".(int)$c->id.", 1, ".(int)$conf->entity.")
                        ON DUPLICATE KEY UPDATE is_site=1";
                $db->query($sql);

                // Create an empty site info row
                $sql = "INSERT INTO ".MAIN_DB_PREFIX."igt_site(entity,fk_soc,fk_contact,datec,tms,fk_user_creat)
                        VALUES (".(int)$conf->entity.", ".(int)$socid.", ".(int)$c->id.", '".$db->idate($now)."', '".$db->idate($now)."', ".(int)$user->id.")
                        ON DUPLICATE KEY UPDATE tms='".$db->idate($now)."'";
                $db->query($sql);

                setEventMessages($langs->trans('SiteCreated'), null, 'mesgs');
                igt_redirect_self($socid, (int)$c->id);
            } else {
                setEventMessages($c->error, $c->errors, 'errors');
            }
        }
    }

    // Save site info (llx_igt_site)
    if ($action === 'save_site_info' && igt_check_token()) {
        $pdl = trim(GETPOST('pdl', 'alphanohtml'));
        $grid_type = GETPOST('grid_type', 'aZ09');    // MONO | TRI
		$pose_mode = GETPOST('pose_mode', 'aZ09');    // INTEG | SURIM
		$install_type = GETPOST('install_type', 'aZ09'); // MICRO | CENTRAL | OPTIM
        $gps = trim(GETPOST('gps', 'alphanohtml'));
        $peak_power_w = (int) GETPOST('peak_power_w', 'int');

        $photoRel = null;
        if (!empty($_FILES['site_photo']['name'])) {
            $ext = strtolower(pathinfo($_FILES['site_photo']['name'], PATHINFO_EXTENSION));
            if (!in_array($ext, array('jpg','jpeg','png','webp'))) {
                setEventMessages($langs->trans('OnlyImagesAllowed'), null, 'errors');
            } else {
                $rel = innogreensites_document_relpath_for_photo($socid, $contactid, $ext);
                $dir = dirname($rel);
				$baseOutput = (!empty($conf->innogreensites->dir_output) ? $conf->innogreensites->dir_output : (DOL_DATA_ROOT.'/innogreensites'));
				$absDir = $baseOutput.'/'.$dir;
                if (dol_mkdir($absDir) < 0) {
                    setEventMessages('Erreur : impossible de créer le répertoire documents du site', null, 'errors');
                } else {
					$baseOutput = (!empty($conf->innogreensites->dir_output) ? $conf->innogreensites->dir_output : (DOL_DATA_ROOT.'/innogreensites'));
					$absFile = $baseOutput.'/'.$rel;
                    $tmp = $_FILES['site_photo']['tmp_name'];
                    if (is_uploaded_file($tmp)) {
                        if (!move_uploaded_file($tmp, $absFile)) {
                            setEventMessages('Erreur : impossible d\'enregistrer la photo', null, 'errors');
                        } else {
                            $photoRel = $rel;
                        }
                    }
                }
            }
        }

		$sql = "INSERT INTO ".MAIN_DB_PREFIX."igt_site(entity,fk_soc,fk_contact,pdl,grid_type,pose_mode,install_type,gps,peak_power_w,photo_file,datec,tms,fk_user_creat)
                VALUES (".(int)$conf->entity.", ".(int)$socid.", ".(int)$contactid.",
                    ".($pdl !== '' ? "'".$db->escape($pdl)."'" : "NULL").",
                    ".($grid_type !== '' ? "'".$db->escape($grid_type)."'" : "NULL").",
                    ".($pose_mode !== '' ? "'".$db->escape($pose_mode)."'" : "NULL").",
		            ".($install_type !== '' ? "'".$db->escape($install_type)."'" : "NULL").",
                    ".($gps !== '' ? "'".$db->escape($gps)."'" : "NULL").",
                    ".($peak_power_w > 0 ? (int)$peak_power_w : "NULL").",
                    ".($photoRel ? "'".$db->escape($photoRel)."'" : "photo_file").",
                    '".$db->idate($now)."','".$db->idate($now)."',".(int)$user->id.")
                ON DUPLICATE KEY UPDATE
                    pdl=VALUES(pdl),
                    grid_type=VALUES(grid_type),
                    pose_mode=VALUES(pose_mode),
		            install_type=VALUES(install_type),
                    gps=VALUES(gps),
                    peak_power_w=VALUES(peak_power_w),
                    photo_file=".($photoRel ? "VALUES(photo_file)" : "photo_file").",
                    tms='".$db->idate($now)."'";

        $res = $db->query($sql);
        if (!$res) {
            setEventMessages($db->lasterror(), null, 'errors');
        } else {
            setEventMessages($langs->trans('Saved'), null, 'mesgs');
        }
        igt_redirect_self($socid, $contactid);
    }

    // Add / Update inverter
    if (($action === 'save_inverter' || $action === 'update_inverter') && igt_check_token()) {
        $equip_identifier = trim(GETPOST('inv_identifier', 'alphanohtml'));
        $manufacturer = trim(GETPOST('inv_manufacturer', 'alphanohtml'));
        $model = trim(GETPOST('inv_model', 'alphanohtml'));
        $pac_w = (int) GETPOST('inv_pac_w', 'int');
        $note = trim(GETPOST('inv_note', 'alphanohtml'));

        if ($equip_identifier === '') {
            setEventMessages($langs->trans('ErrorFieldRequired', $langs->trans('EquipmentIdentifier')), null, 'errors');
            igt_redirect_self($socid, $contactid);
        }

        $eq = new IgtEquipment($db);
        $eq->entity = $conf->entity;
        $eq->fk_soc = $socid;
        $eq->fk_contact = $contactid;
        $eq->equip_type = 'INVERTER';
        $eq->equip_identifier = $equip_identifier;
        $eq->manufacturer = $manufacturer;
        $eq->model = $model;
        $eq->pac_w = ($pac_w > 0 ? $pac_w : null);
        $eq->note = ($note !== '' ? $note : null);

        if ($action === 'update_inverter') {
            $eq->id = (int) GETPOST('inv_id', 'int');
            $res = $eq->update($user);
        } else {
            $res = $eq->create($user);
        }

        if ($res < 0) setEventMessages($eq->error, $eq->errors, 'errors');
        else setEventMessages($langs->trans('Saved'), null, 'mesgs');

        igt_redirect_self($socid, $contactid);
    }

    // Add / Update module
    if (($action === 'save_module' || $action === 'update_module') && igt_check_token()) {
        $equip_identifier = trim(GETPOST('mod_identifier', 'alphanohtml'));
        $manufacturer = trim(GETPOST('mod_manufacturer', 'alphanohtml'));
        $model = trim(GETPOST('mod_model', 'alphanohtml'));
        $pmp  = (int) GETPOST('mod_pmp_w', 'int');
        $voc  = GETPOST('mod_voc_v', 'alpha');
        $isc  = GETPOST('mod_isc_a', 'alpha');
        $note = trim(GETPOST('mod_note', 'alphanohtml'));

        if ($equip_identifier === '') {
            setEventMessages($langs->trans('ErrorFieldRequired', $langs->trans('EquipmentIdentifier')), null, 'errors');
            igt_redirect_self($socid, $contactid);
        }

        $eq = new IgtEquipment($db);
        $eq->entity = $conf->entity;
        $eq->fk_soc = $socid;
        $eq->fk_contact = $contactid;
        $eq->equip_type = 'MODULE';
        $eq->equip_identifier = $equip_identifier;
        $eq->manufacturer = $manufacturer;
        $eq->model = $model;
        $eq->pmp_w = ($pmp > 0 ? $pmp : null);
        $eq->voc_v = (!empty($voc) ? (float) str_replace(',', '.', $voc) : null);
        $eq->isc_a = (!empty($isc) ? (float) str_replace(',', '.', $isc) : null);
        $eq->note = ($note !== '' ? $note : null);

        if ($action === 'update_module') {
            $eq->id = (int) GETPOST('mod_id', 'int');
            $res = $eq->update($user);
        } else {
            $res = $eq->create($user);
        }

        if ($res < 0) setEventMessages($eq->error, $eq->errors, 'errors');
        else setEventMessages($langs->trans('Saved'), null, 'mesgs');

        igt_redirect_self($socid, $contactid);
    }

    // Add / Update string
    if (($action === 'save_string' || $action === 'update_string') && igt_check_token()) {
        $string_identifier = trim(GETPOST('st_identifier', 'alphanohtml'));
        $inv  = (int) GETPOST('st_inverter', 'int');
        $mppt = (int) GETPOST('st_mppt', 'int');
		$moduleEqId = (int) GETPOST('st_module_eq', 'int'); // for Voc/Isc prefill
        $mser = (int) GETPOST('st_modules_series', 'int');
        $mpar = (int) GETPOST('st_strings_parallel', 'int');
        $voc  = GETPOST('st_voc', 'alpha');
        $isc  = GETPOST('st_isc', 'alpha');
        $note = trim(GETPOST('st_note', 'alphanohtml'));

        if ($string_identifier === '') {
            setEventMessages($langs->trans('ErrorFieldRequired', $langs->trans('StringIdentifier')), null, 'errors');
            igt_redirect_self($socid, $contactid);
        }
        if ($inv <= 0) {
            setEventMessages($langs->trans('ErrorFieldRequired', $langs->trans('Inverter')), null, 'errors');
            igt_redirect_self($socid, $contactid);
        }

        $st = new IgtString($db);
        $st->entity = $conf->entity;
        $st->fk_soc = $socid;
        $st->fk_contact = $contactid;
        $st->string_identifier = $string_identifier;
        $st->fk_inverter_eq = $inv;
        $st->mppt_no = ($mppt > 0 ? $mppt : null);
		// $st->string_no not used in UI
        $st->modules_in_series = ($mser > 0 ? $mser : null);
        $st->strings_in_parallel = ($mpar > 0 ? $mpar : 1);

		$vocVal = (!empty($voc) ? (float) str_replace(',', '.', $voc) : null);
		$iscVal = (!empty($isc) ? (float) str_replace(',', '.', $isc) : null);

		// If user leaves Voc/Isc empty, propose a default based on selected module + number of modules
		if (($vocVal === null || $iscVal === null) && $moduleEqId > 0 && $mser > 0) {
			$sql = "SELECT voc_v, isc_a FROM ".MAIN_DB_PREFIX."igt_equipment
				WHERE entity=".(int)$conf->entity.
				" AND fk_soc=".(int)$socid.
				" AND fk_contact=".(int)$contactid.
				" AND equip_type='MODULE' AND rowid=".(int)$moduleEqId;
			$res = $db->query($sql);
			if ($res && ($o = $db->fetch_object($res))) {
				$voc_module = ($o->voc_v !== null ? (float)$o->voc_v : null);
				$isc_module = ($o->isc_a !== null ? (float)$o->isc_a : null);
				if ($vocVal === null && $voc_module !== null) $vocVal = $voc_module * (int)$mser;
				if ($iscVal === null && $isc_module !== null) $iscVal = $isc_module * max(1, (int)$mpar);
			}
		}

		$st->voc_string_v = $vocVal;
		$st->isc_string_a = $iscVal;
        $st->note = ($note !== '' ? $note : null);

        if ($action === 'update_string') {
            $st->id = (int) GETPOST('st_id', 'int');
            $res = $st->update($user);
        } else {
            $res = $st->create($user);
        }

        if ($res < 0) setEventMessages($st->error, $st->errors, 'errors');
        else setEventMessages($langs->trans('Saved'), null, 'mesgs');

        igt_redirect_self($socid, $contactid);
    }

    // Add / Update battery
    if (($action === 'save_battery' || $action === 'update_battery') && igt_check_token()) {
        $bat_identifier = trim(GETPOST('bat_identifier', 'alphanohtml'));
        $manufacturer = trim(GETPOST('bat_manufacturer', 'alphanohtml'));
        $model = trim(GETPOST('bat_model', 'alphanohtml'));
        $capacity_kwh = GETPOST('bat_capacity_kwh', 'alpha');
        $voltage_v = GETPOST('bat_voltage_v', 'alpha');

        if ($bat_identifier === '') {
            setEventMessages($langs->trans('ErrorFieldRequired', $langs->trans('BatteryIdentifier')), null, 'errors');
            igt_redirect_self($socid, $contactid);
        }

        $cap = (!empty($capacity_kwh) ? (float) str_replace(',', '.', $capacity_kwh) : null);
        $vol = (!empty($voltage_v) ? (float) str_replace(',', '.', $voltage_v) : null);

        $batid = (int) GETPOST('bat_id', 'int');
        if ($action === 'update_battery' && $batid > 0) {
            $sql = "UPDATE ".MAIN_DB_PREFIX."igt_battery SET
                        battery_identifier=".($bat_identifier !== '' ? "'".$db->escape($bat_identifier)."'" : "NULL").",
                        manufacturer=".($manufacturer !== '' ? "'".$db->escape($manufacturer)."'" : "NULL").",
                        model=".($model !== '' ? "'".$db->escape($model)."'" : "NULL").",
                        capacity_kwh=".($cap !== null ? (float)$cap : "NULL").",
                        voltage_v=".($vol !== null ? (float)$vol : "NULL").",
                        tms='".$db->idate($now)."'
                    WHERE rowid=".$batid." AND entity=".(int)$conf->entity;
        } else {
            $sql = "INSERT INTO ".MAIN_DB_PREFIX."igt_battery(entity,fk_soc,fk_contact,battery_identifier,manufacturer,model,capacity_kwh,voltage_v,datec,tms,fk_user_creat)
                    VALUES (".(int)$conf->entity.",".(int)$socid.",".(int)$contactid.",
                        ".($bat_identifier !== '' ? "'".$db->escape($bat_identifier)."'" : "NULL").",
                        ".($manufacturer !== '' ? "'".$db->escape($manufacturer)."'" : "NULL").",
                        ".($model !== '' ? "'".$db->escape($model)."'" : "NULL").",
                        ".($cap !== null ? (float)$cap : "NULL").",
                        ".($vol !== null ? (float)$vol : "NULL").",
                        '".$db->idate($now)."','".$db->idate($now)."',".(int)$user->id.")";
        }

        $res = $db->query($sql);
        if (!$res) setEventMessages($db->lasterror(), null, 'errors');
        else setEventMessages($langs->trans('Saved'), null, 'mesgs');

        igt_redirect_self($socid, $contactid);
    }

    // Deletes (POST only)
    if ($action === 'delete_equipment' && igt_check_token()) {
        $eq = new IgtEquipment($db);
        $eq->id = $id;
        $res = $eq->delete($user);
        if ($res < 0) setEventMessages($eq->error, $eq->errors, 'errors');
        else setEventMessages($langs->trans('Deleted'), null, 'mesgs');
        igt_redirect_self($socid, $contactid);
    }

    if ($action === 'delete_string' && igt_check_token()) {
        $st = new IgtString($db);
        $st->id = $id;
        $res = $st->delete($user);
        if ($res < 0) setEventMessages($st->error, $st->errors, 'errors');
        else setEventMessages($langs->trans('Deleted'), null, 'mesgs');
        igt_redirect_self($socid, $contactid);
    }

    if ($action === 'delete_battery' && igt_check_token()) {
        $sql = "DELETE FROM ".MAIN_DB_PREFIX."igt_battery WHERE rowid=".(int)$id." AND entity=".(int)$conf->entity;
        $res = $db->query($sql);
        if (!$res) setEventMessages($db->lasterror(), null, 'errors');
        else setEventMessages($langs->trans('Deleted'), null, 'mesgs');
        igt_redirect_self($socid, $contactid);
    }
}

// -----------------------------------------------------------------------------
// READ
// -----------------------------------------------------------------------------
$sites = innogreensites_get_sites($db, $socid);
if (empty($contactid) && !empty($sites)) $contactid = (int)$sites[0]['id'];

$siteInfo = ($contactid ? innogreensites_get_site_info($db, $socid, $contactid) : null);

$inverters = ($contactid ? IgtEquipment::fetchAllByType($db, $conf->entity, $socid, $contactid, 'INVERTER') : array());
$prefLastInverter = (!empty($inverters) ? end($inverters) : null);
if (!empty($inverters)) { reset($inverters); }

$modules   = ($contactid ? IgtEquipment::fetchAllByType($db, $conf->entity, $socid, $contactid, 'MODULE') : array());
$strings   = ($contactid ? IgtString::fetchAll($db, $conf->entity, $socid, $contactid) : array());

$batteries = array();
if ($contactid) {
    $sql = "SELECT rowid, battery_identifier, manufacturer, model, capacity_kwh, voltage_v
            FROM ".MAIN_DB_PREFIX."igt_battery
            WHERE entity=".(int)$conf->entity." AND fk_soc=".(int)$socid." AND fk_contact=".(int)$contactid."
            ORDER BY rowid DESC";
    $res = $db->query($sql);
    if ($res) while ($o = $db->fetch_object($res)) $batteries[] = (array)$o;
}

// Prefill edit forms
$editInverter = null;
$editModule = null;
$editString = null;
$editBattery = null;

if ($action === 'edit_inverter' && $id > 0) $editInverter = IgtEquipment::fetchOne($db, $conf->entity, $id);
if ($action === 'edit_module' && $id > 0) $editModule = IgtEquipment::fetchOne($db, $conf->entity, $id);
if ($action === 'edit_string' && $id > 0) $editString = IgtString::fetchOne($db, $conf->entity, $id);
if ($action === 'edit_battery' && $id > 0) {
    $res = $db->query("SELECT rowid, battery_identifier, manufacturer, model, capacity_kwh, voltage_v FROM ".MAIN_DB_PREFIX."igt_battery WHERE entity=".(int)$conf->entity." AND rowid=".(int)$id);
    if ($res && ($o=$db->fetch_object($res))) $editBattery = (array)$o;
}

// -----------------------------------------------------------------------------
// UI
// -----------------------------------------------------------------------------
llxHeader('', $langs->trans('SitesPV'));
// --- Page CSS tweaks (compact actions, centered add buttons) ---
print '<style>
.ig-actions{white-space:nowrap;}
.ig-actions a.button, .ig-actions input.button{
  padding:2px 8px !important;
  font-size:11px !important;
  line-height:1.3 !important;
}
.ig-actions form{display:inline-block;margin:0 0 0 6px;}
.ig-addbtn-wrap{margin:10px 0 18px 0;text-align:center;}
.ig-addbtn-wrap .button{min-width:220px;}
.ig-togglebox{margin-top:10px;}
.ig-photo-preview{max-width:420px;max-height:240px;border:1px solid #ddd;border-radius:6px;display:block;margin-top:8px;}
</style>';

// JS helpers: show/hide sections + prefill Voc/Isc on string form
print "\n<script>\n";
print "function igtToggle(id){var e=document.getElementById(id); if(!e) return; var s=e.style.display; e.style.display=(s==='none'||s==='')?'block':'none';}\n";
print "function igtPrefillString(idx){\n";
print "  var modSel=document.getElementById('st_module_eq_'+idx);\n";
print "  var ser=document.getElementById('st_modules_series_'+idx);\n";
print "  var par=document.getElementById('st_strings_parallel_'+idx);\n";
print "  var voc=document.getElementById('st_voc_'+idx);\n";
print "  var isc=document.getElementById('st_isc_'+idx);\n";
print "  if(!modSel||!ser||!par||!voc||!isc) return;\n";
print "  var opt=modSel.options[modSel.selectedIndex];\n";
print "  var vocm=parseFloat((opt && opt.dataset && opt.dataset.voc) ? opt.dataset.voc : '');\n";
print "  var iscm=parseFloat((opt && opt.dataset && opt.dataset.isc) ? opt.dataset.isc : '');\n";
print "  var nser=parseInt(ser.value||'0',10);\n";
print "  var npar=parseInt(par.value||'1',10);\n";
print "  if(!isNaN(vocm) && nser>0){ voc.value = (vocm*nser).toFixed(1); }\n";
print "  if(!isNaN(iscm) && npar>0){ isc.value = (iscm*npar).toFixed(1); }\n";
print "}\n";
print "</script>\n";

print '<div class="igt_headerbar">';
print '<div class="igt_header_title"><h2>'.$langs->trans('SitesPV').' - '.dol_escape_htmltag($thirdpartyName).'</h2></div>';
print '<div class="igt_header_actions">';
print '<a class="button" href="'.DOL_URL_ROOT.'/contact/card.php?action=create&socid='.$socid.'&backtopage='.urlencode($_SERVER['PHP_SELF'].'?socid='.$socid).'">'.$langs->trans('Créer un site').'</a> ';
print '<a class="button" href="'.DOL_URL_ROOT.'/societe/card.php?socid='.$socid.'">'.$langs->trans('Retour à la fiche du tiers').'</a>';
print '</div></div>';
print '<br>';

// Quick navigation
print '<div class="igt_header_actions" style="text-align:right;margin:6px 0 14px 0;">';
print '<a class="button" href="'.DOL_URL_ROOT.'/contact/card.php?action=create&socid='.$socid.'&backtopage='.urlencode($_SERVER['PHP_SELF'].'?socid='.$socid).'">'.$langs->trans('Créer un site').'</a> ';
print '<a class="button" href="'.DOL_URL_ROOT.'/societe/card.php?socid='.$socid.'">'.$langs->trans('Retour à la fiche du tiers').'</a>';
print '</div>';

// If module tables missing, show a friendly warning
$missing = array();
$checkTables = array('llx_igt_site','llx_igt_battery','llx_igt_equipment','llx_igt_string');
foreach ($checkTables as $t) {
    $res = $db->query("SHOW TABLES LIKE '".$db->escape($t)."'");
    if (!$res || $db->num_rows($res) === 0) $missing[] = $t;
}
if (!empty($missing)) {
    print '<div class="warning">';
    print 'Tables manquantes : <b>'.dol_escape_htmltag(implode(', ', $missing)).'</b><br>';
    print 'Solution rapide (MySQL) : importer les fichiers SQL dans <code>custom/innogreensites/sql/</code>, puis désactiver / réactiver le module, ou exécuter les CREATE TABLE à la main.';
    print '</div><br>';
}

// Site selector + create site
print '<div class="fichecenter">';
print '<div class="fichehalfleft">';
print '<form method="GET" action="'.$_SERVER['PHP_SELF'].'">';
print '<input type="hidden" name="socid" value="'.$socid.'">';

print '<b>'.$langs->trans('Site').' :</b> ';
print '<select name="contactid">';
if (empty($sites)) {
    print '<option value="0" selected>— Aucun site —</option>';
} else {
    foreach ($sites as $s) {
        $sel = ((int)$s['id'] === (int)$contactid) ? ' selected' : '';
        print '<option value="'.$s['id'].'"'.$sel.'>'.dol_escape_htmltag($s['label']).'</option>';
    }
}
print '</select> ';
print '<input class="button" type="submit" value="'.$langs->trans('Select').'">';
print '</form>';

if ($user->hasRight('innogreensites', 'write')) {
    print '<br><br><form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
    print '<input type="hidden" name="token" value="'.newToken().'">';
    print '<input type="hidden" name="action" value="create_site">';
    print '<input type="hidden" name="socid" value="'.$socid.'">';
    print '<label><b>'.$langs->trans('CreateSite').'</b></label><br>';
    print '<input type="text" name="site_name" size="40" placeholder="Nom du site (ex : Maison - Perrigny-sur-Loire)"> ';
    print '<input class="button" type="submit" value="'.$langs->trans('Create').'">';
    print '</form>';
    print '</div>';
}
print '</div>';
print '</div>';

if (!$contactid) {
    llxFooter();
    exit;
}

// -----------------------------------------------------------------------------
// Site info header
// -----------------------------------------------------------------------------
$photoUrl = '';
if (!empty($siteInfo['photo_file'])) {
    $photoUrl = innogreensites_get_photo_url($siteInfo['photo_file']);
}

print '<hr>';
print '<h3>Informations du site</h3>';

print '<form method="POST" enctype="multipart/form-data" action="'.$_SERVER['PHP_SELF'].'">';
print '<input type="hidden" name="token" value="'.newToken().'">';
print '<input type="hidden" name="action" value="save_site_info">';
print '<input type="hidden" name="socid" value="'.$socid.'">';
print '<input type="hidden" name="contactid" value="'.$contactid.'">';

print '<table class="noborder centpercent">';
print '<tr class="liste_titre"><td colspan="2">Paramètres généraux</td></tr>';

print '<tr><td style="width: 240px;">Numéro de point de livraison (PDL / PRM)</td><td><input type="text" name="pdl" value="'.dol_escape_htmltag($siteInfo['pdl'] ?? '').'" size="30"></td></tr>';

print '<tr><td>Type de réseau</td><td>';
$gt = $siteInfo['grid_type'] ?? '';
print '<select name="grid_type">';
print '<option value=""></option>';
print '<option value="MONO"'.($gt==='MONO'?' selected':'').'>Monophasé</option>';
print '<option value="TRI"'.($gt==='TRI'?' selected':'').'>Triphasé</option>';
print '</select>';
print '</td></tr>';

print '<tr><td>Mode de pose</td><td>';
$pm = $siteInfo['pose_mode'] ?? '';
print '<select name="pose_mode">';
print '<option value=""></option>';
print '<option value="INTEG"'.($pm==='INTEG'?' selected':'').'>Intégration</option>';
print '<option value="SURI"'.($pm==='SURI'?' selected':'').'>Surimposition</option>';
print '</select>';
print '</td></tr>';

print '<tr><td>Type d\'installation</td><td>';
$it = $siteInfo['install_type'] ?? '';
print '<select name="install_type">';
$itOptions = array(
    '' => '-',
    'MICRO' => 'Micro-onduleur',
    'CENTRAL' => 'Onduleur central',
    'OPTIM' => 'Optimiseur'
);
foreach ($itOptions as $code => $label) {
    $sel = ($it === $code) ? ' selected' : '';
    print '<option value="'.dol_escape_htmltag($code).'"'.$sel.'>'.dol_escape_htmltag($label).'</option>';
}
print '</select>';
print '</td></tr>';

print '<tr><td>Coordonnées GPS</td><td><input type="text" name="gps" value="'.dol_escape_htmltag($siteInfo['gps'] ?? '').'" size="40" placeholder="ex : 46.6789, 3.1234"></td></tr>';

print '<tr><td>Puissance crête du site (Wc)</td><td><input type="number" name="peak_power_w" value="'.dol_escape_htmltag($siteInfo['peak_power_w'] ?? '').'" min="0" step="1"></td></tr>';

print '<tr><td>Photo du site</td><td>';
print '<input type="file" name="site_photo" accept="image/*"> ';
if ($photoUrl) {
	    $cache = time();
	    $sep = (strpos($photoUrl, '?') !== false ? '&' : '?');
        print '<div style="margin-top:8px;"><img class="ig-photo-preview" src="'.$photoUrl.((strpos($photoUrl,'?')===false)?'?':'&').'cache='.$cache.'" alt="Photo du site"></div>';
}
print '</td></tr>';

print '</table>';

if ($user->hasRight('innogreensites','write')) {
    print '<br><input class="button button-save" type="submit" value="'.$langs->trans('Save').'">';
}
print '</form>';

// -----------------------------------------------------------------------------
// Existing lists (TOP) + forms (BOTTOM)
// -----------------------------------------------------------------------------
print '<hr><h3>Onduleurs</h3>';

print '<table class="noborder centpercent">';
print '<tr class="liste_titre">';
print '<td>Identifiant</td><td>Fabricant</td><td>Référence</td><td>Puissance AC (W)</td><td>Note</td><td style="width:160px;">Actions</td>';
print '</tr>';
foreach ($inverters as $row) {
    print '<tr class="oddeven">';
    print '<td><b>'.dol_escape_htmltag($row['equip_identifier'] ?? '').'</b></td>';
    print '<td>'.dol_escape_htmltag($row['manufacturer'] ?? '').'</td>';
    print '<td>'.dol_escape_htmltag($row['model'] ?? '').'</td>';
    print '<td>'.dol_escape_htmltag($row['pac_w'] ?? '').'</td>';
    print '<td>'.dol_escape_htmltag($row['note'] ?? '').'</td>';
    print '<td>';
    print '<a class="button button-small" href="'.$_SERVER['PHP_SELF'].'?socid='.$socid.'&contactid='.$contactid.'&action=edit_inverter&id='.(int)$row['rowid'].'">Modifier</a> ';
    if ($user->hasRight('innogreensites','write')) {
        print '<form style="display:inline" method="POST" action="'.$_SERVER['PHP_SELF'].'">';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        print '<input type="hidden" name="action" value="delete_equipment">';
        print '<input type="hidden" name="socid" value="'.$socid.'">';
        print '<input type="hidden" name="contactid" value="'.$contactid.'">';
        print '<input type="hidden" name="id" value="'.(int)$row['rowid'].'">';
        print '<input class="button button-delete button-small" type="submit" value="Supprimer" onclick="return confirm(\'Supprimer cet onduleur ? Les chaînes associées seront aussi supprimées.\');">';
        print '</form>';
    }
    print '</td>';
    print '</tr>';
}
if (empty($inverters)) {
    print '<tr><td colspan="6" class="opacitymedium">Aucun onduleur enregistré.</td></tr>';
}
print '</table>';

print '<hr><h3>Modules photovoltaïques</h3>';

print '<table class="noborder centpercent">';
print '<tr class="liste_titre">';
print '<td>Identifiant</td><td>Fabricant</td><td>Référence</td><td>Pmpp (W)</td><td>Voc (V)</td><td>Isc (A)</td><td>Note</td><td style="width:160px;">Actions</td>';
print '</tr>';
foreach ($modules as $row) {
    print '<tr class="oddeven">';
    print '<td><b>'.dol_escape_htmltag($row['equip_identifier'] ?? '').'</b></td>';
    print '<td>'.dol_escape_htmltag($row['manufacturer'] ?? '').'</td>';
    print '<td>'.dol_escape_htmltag($row['model'] ?? '').'</td>';
    print '<td>'.dol_escape_htmltag($row['pmp_w'] ?? '').'</td>';
    print '<td>'.dol_escape_htmltag($row['voc_v'] ?? '').'</td>';
    print '<td>'.dol_escape_htmltag($row['isc_a'] ?? '').'</td>';
    print '<td>'.dol_escape_htmltag($row['note'] ?? '').'</td>';
    print '<td>';
    print '<a class="button button-small" href="'.$_SERVER['PHP_SELF'].'?socid='.$socid.'&contactid='.$contactid.'&action=edit_module&id='.(int)$row['rowid'].'">Modifier</a> ';
    if ($user->hasRight('innogreensites','write')) {
        print '<form style="display:inline" method="POST" action="'.$_SERVER['PHP_SELF'].'">';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        print '<input type="hidden" name="action" value="delete_equipment">';
        print '<input type="hidden" name="socid" value="'.$socid.'">';
        print '<input type="hidden" name="contactid" value="'.$contactid.'">';
        print '<input type="hidden" name="id" value="'.(int)$row['rowid'].'">';
        print '<input class="button button-delete button-small" type="submit" value="Supprimer" onclick="return confirm(\'Supprimer ce module ?\');">';
        print '</form>';
    }
    print '</td>';
    print '</tr>';
}
if (empty($modules)) {
    print '<tr><td colspan="8" class="opacitymedium">Aucun module enregistré.</td></tr>';
}
print '</table>';

print '<hr><h3>Chaînes (strings)</h3>';

print '<table class="noborder centpercent">';
print '<tr class="liste_titre">';
print '<td>Identifiant</td><td>Onduleur</td><td>MPPT</td><td>Modules en série</td><td>Chaînes en parallèle</td><td>Voc (V)</td><td>Isc (A)</td><td>Note</td><td style="width:160px;">Actions</td>';
print '</tr>';
foreach ($strings as $row) {
    $invLabel = trim(($row['inverter_identifier'] ?? '').' '.($row['inverter_manufacturer'] ?? '').' '.($row['inverter_model'] ?? ''));
    print '<tr class="oddeven">';
    print '<td><b>'.dol_escape_htmltag($row['string_identifier'] ?? '').'</b></td>';
    print '<td>'.dol_escape_htmltag($invLabel).'</td>';
    print '<td>'.dol_escape_htmltag($row['mppt_no'] ?? '').'</td>';
    print '<td>'.dol_escape_htmltag($row['modules_in_series'] ?? '').'</td>';
    print '<td>'.dol_escape_htmltag($row['strings_in_parallel'] ?? '').'</td>';
    print '<td>'.dol_escape_htmltag($row['voc_string_v'] ?? '').'</td>';
    print '<td>'.dol_escape_htmltag($row['isc_string_a'] ?? '').'</td>';
    print '<td>'.dol_escape_htmltag($row['note'] ?? '').'</td>';
    print '<td>';
    print '<a class="button button-small" href="'.$_SERVER['PHP_SELF'].'?socid='.$socid.'&contactid='.$contactid.'&action=edit_string&id='.(int)$row['rowid'].'">Modifier</a> ';
    if ($user->hasRight('innogreensites','write')) {
        print '<form style="display:inline" method="POST" action="'.$_SERVER['PHP_SELF'].'">';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        print '<input type="hidden" name="action" value="delete_string">';
        print '<input type="hidden" name="socid" value="'.$socid.'">';
        print '<input type="hidden" name="contactid" value="'.$contactid.'">';
        print '<input type="hidden" name="id" value="'.(int)$row['rowid'].'">';
        print '<input class="button button-delete button-small" type="submit" value="Supprimer" onclick="return confirm(\'Supprimer cette chaîne ?\');">';
        print '</form>';
    }
    print '</td>';
    print '</tr>';
}
if (empty($strings)) {
    print '<tr><td colspan="10" class="opacitymedium">Aucune chaîne enregistrée.</td></tr>';
}
print '</table>';

print '<hr><h3>Batteries</h3>';
print '<table class="noborder centpercent">';
print '<tr class="liste_titre">';
print '<td>Identifiant</td><td>Fabricant</td><td>Référence</td><td>Capacité (kWh)</td><td>Tension (V)</td><td style="width:160px;">Actions</td>';
print '</tr>';
foreach ($batteries as $row) {
    print '<tr class="oddeven">';
    print '<td><b>'.dol_escape_htmltag($row['battery_identifier'] ?? '').'</b></td>';
    print '<td>'.dol_escape_htmltag($row['manufacturer'] ?? '').'</td>';
    print '<td>'.dol_escape_htmltag($row['model'] ?? '').'</td>';
    print '<td>'.dol_escape_htmltag($row['capacity_kwh'] ?? '').'</td>';
    print '<td>'.dol_escape_htmltag($row['voltage_v'] ?? '').'</td>';
    print '<td>';
    print '<a class="button button-small" href="'.$_SERVER['PHP_SELF'].'?socid='.$socid.'&contactid='.$contactid.'&action=edit_battery&id='.(int)$row['rowid'].'">Modifier</a> ';
    if ($user->hasRight('innogreensites','write')) {
        print '<form style="display:inline" method="POST" action="'.$_SERVER['PHP_SELF'].'">';
        print '<input type="hidden" name="token" value="'.newToken().'">';
        print '<input type="hidden" name="action" value="delete_battery">';
        print '<input type="hidden" name="socid" value="'.$socid.'">';
        print '<input type="hidden" name="contactid" value="'.$contactid.'">';
        print '<input type="hidden" name="id" value="'.(int)$row['rowid'].'">';
        print '<input class="button button-delete button-small" type="submit" value="Supprimer" onclick="return confirm(\'Supprimer cette batterie ?\');">';
        print '</form>';
    }
    print '</td>';
    print '</tr>';
}
if (empty($batteries)) {
    print '<tr><td colspan="6" class="opacitymedium">Aucune batterie enregistrée.</td></tr>';
}
print '</table>';

// -----------------------------------------------------------------------------
// FORMS (BOTTOM)
// -----------------------------------------------------------------------------
if ($user->hasRight('innogreensites', 'write')) {

    $showInvForm = (!empty($editInverter) || $action === 'add_inverter');
    print '<hr><div style="margin-bottom:10px;">';
    print '<a class="butAction" href="#" onclick="igtToggle(\'igt_form_inv\');return false;">'.($editInverter ? 'Modifier cet onduleur' : 'Ajouter un onduleur').'</a>';
    print '</div>';
    print '<div id="igt_form_inv" style="display:'.($showInvForm ? 'block' : 'none').';">';
    print '<h3>'.($editInverter ? 'Modification de l\'onduleur' : 'Nouvel onduleur').'</h3>';
    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
    print '<input type="hidden" name="token" value="'.newToken().'">';
    print '<input type="hidden" name="socid" value="'.$socid.'">';
    print '<input type="hidden" name="contactid" value="'.$contactid.'">';
    if ($editInverter) {
        print '<input type="hidden" name="action" value="update_inverter">';
        print '<input type="hidden" name="inv_id" value="'.(int)$editInverter['rowid'].'">';
    } else {
        print '<input type="hidden" name="action" value="save_inverter">';
    }

    print '<table class="noborder centpercent">';
    print '<tr><td style="width:240px;">Identifiant (texte)</td><td><input type="text" name="inv_identifier" size="20" value="'.dol_escape_htmltag($editInverter['equip_identifier'] ?? '').'" placeholder="ex : INV-1" required></td></tr>';
    print '<tr><td>Fabricant</td><td><input type="text" name="inv_manufacturer" size="30" value="'.dol_escape_htmltag((!empty($editInverter) ? ($editInverter['manufacturer'] ?? '') : (!empty($prefLastInverter['manufacturer']) ? $prefLastInverter['manufacturer'] : ''))).'"></td></tr>';
    print '<tr><td>Référence</td><td><input type="text" name="inv_model" size="30" value="'.dol_escape_htmltag((!empty($editInverter) ? ($editInverter['model'] ?? '') : (!empty($prefLastInverter['model']) ? $prefLastInverter['model'] : ''))).'"></td></tr>';
    print '<tr><td>Puissance AC (W)</td><td><input type="number" name="inv_pac_w" min="0" step="1" value="'.dol_escape_htmltag($editInverter['pac_w'] ?? '').'"></td></tr>';
    print '<tr><td>Note</td><td><input type="text" name="inv_note" size="60" value="'.dol_escape_htmltag($editInverter['note'] ?? '').'"></td></tr>';
    print '</table>';
    print '<br><input class="button button-save" type="submit" value="'.$langs->trans('Save').'"> ';
    if ($editInverter) print '<a class="button" href="'.$_SERVER['PHP_SELF'].'?socid='.$socid.'&contactid='.$contactid.'">Annuler</a>';
    print '</form>';
    print '</div>';

    $showModForm = (!empty($editModule) || $action === 'add_module');
    print '<hr><div style="margin-bottom:10px;">';
    print '<a class="butAction" href="#" onclick="igtToggle(\'igt_form_mod\');return false;">'.($editModule ? 'Modifier ce module photovoltaïque' : 'Ajouter un module photovoltaïque').'</a>';
    print '</div>';
    print '<div id="igt_form_mod" style="display:'.($showModForm ? 'block' : 'none').';">';
    print '<h3>'.($editModule ? 'Modification du module photovoltaïque' : 'Nouveau module photovoltaïque').'</h3>';
    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
    print '<input type="hidden" name="token" value="'.newToken().'">';
    print '<input type="hidden" name="socid" value="'.$socid.'">';
    print '<input type="hidden" name="contactid" value="'.$contactid.'">';
    if ($editModule) {
        print '<input type="hidden" name="action" value="update_module">';
        print '<input type="hidden" name="mod_id" value="'.(int)$editModule['rowid'].'">';
    } else {
        print '<input type="hidden" name="action" value="save_module">';
    }

    print '<table class="noborder centpercent">';
    print '<tr><td style="width:240px;">Identifiant (texte)</td><td><input type="text" name="mod_identifier" size="20" value="'.dol_escape_htmltag($editModule['equip_identifier'] ?? '').'" placeholder="ex : MOD-A" required></td></tr>';
    print '<tr><td>Fabricant</td><td><input type="text" name="mod_manufacturer" size="30" value="'.dol_escape_htmltag($editModule['manufacturer'] ?? '').'"></td></tr>';
    print '<tr><td>Référence</td><td><input type="text" name="mod_model" size="30" value="'.dol_escape_htmltag($editModule['model'] ?? '').'"></td></tr>';
    print '<tr><td>Pmpp (W)</td><td><input type="number" name="mod_pmp_w" min="0" step="1" value="'.dol_escape_htmltag($editModule['pmp_w'] ?? '').'"></td></tr>';
    print '<tr><td>Voc (V)</td><td><input type="text" name="mod_voc_v" size="10" value="'.dol_escape_htmltag($editModule['voc_v'] ?? '').'"></td></tr>';
    print '<tr><td>Isc (A)</td><td><input type="text" name="mod_isc_a" size="10" value="'.dol_escape_htmltag($editModule['isc_a'] ?? '').'"></td></tr>';
    print '<tr><td>Note</td><td><input type="text" name="mod_note" size="60" value="'.dol_escape_htmltag($editModule['note'] ?? '').'"></td></tr>';
    print '</table>';
    print '<br><input class="button button-save" type="submit" value="'.$langs->trans('Save').'"> ';
    if ($editModule) print '<a class="button" href="'.$_SERVER['PHP_SELF'].'?socid='.$socid.'&contactid='.$contactid.'">Annuler</a>';
    print '</form>';
    print '</div>';

    $showStrForm = (!empty($editString) || $action === 'add_string');
    print '<hr><div style="margin-bottom:10px;">';
    print '<a class="butAction" href="#" onclick="igtToggle(\'igt_form_str\');return false;">'.($editString ? 'Modifier cette chaîne' : 'Ajouter une chaîne').'</a>';
    print '</div>';
    print '<div id="igt_form_str" style="display:'.($showStrForm ? 'block' : 'none').';">';
    print '<h3>'.($editString ? 'Modification de la chaîne' : 'Nouvelle chaîne').'</h3>';
    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
    print '<input type="hidden" name="token" value="'.newToken().'">';
    print '<input type="hidden" name="socid" value="'.$socid.'">';
    print '<input type="hidden" name="contactid" value="'.$contactid.'">';
    if ($editString) {
        print '<input type="hidden" name="action" value="update_string">';
        print '<input type="hidden" name="st_id" value="'.(int)$editString['rowid'].'">';
    } else {
        print '<input type="hidden" name="action" value="save_string">';
    }

    print '<table class="noborder centpercent">';
    print '<tr><td style="width:240px;">Identifiant (texte)</td><td><input type="text" name="st_identifier" size="20" value="'.dol_escape_htmltag($editString['string_identifier'] ?? '').'" placeholder="ex : STR-1" required></td></tr>';

    print '<tr><td>Onduleur associé</td><td><select name="st_inverter" required>';
    print '<option value=""></option>';
    foreach ($inverters as $inv) {
        $label = trim(($inv['equip_identifier'] ?? '').' - '.($inv['manufacturer'] ?? '').' '.($inv['model'] ?? ''));
        $sel = ($editString && (int)$editString['fk_inverter_eq'] === (int)$inv['rowid']) ? ' selected' : '';
        print '<option value="'.(int)$inv['rowid'].'"'.$sel.'>'.dol_escape_htmltag($label).'</option>';
    }
    print '</select></td></tr>';

    // Use a module reference only to prefill Voc/Isc (no auto mode)
    print '<tr><td>MPPT</td><td><input type="number" id="st_mppt" name="st_mppt" min="0" step="1" value="'.dol_escape_htmltag($editString['mppt_no'] ?? '').'"></td></tr>';

    print '<tr><td>Modèle de module (préremplissage Voc/Isc)</td><td>';
    print '<select name="st_module_eq" id="st_module_eq_0" onchange="igtPrefillString(0)">';
    print '<option value="">-</option>';
    foreach ($modules as $m) {
        $label = trim(($m['equip_identifier'] ?? '').' - '.($m['manufacturer'] ?? '').' '.($m['model'] ?? ''));
        $sel = '';
        print '<option value="'.(int)$m['rowid'].'" data-voc="'.dol_escape_htmltag($m['voc_v'] ?? '').'" data-isc="'.dol_escape_htmltag($m['isc_a'] ?? '').'"'.$sel.'>'.dol_escape_htmltag($label).'</option>';
    }
    print '</select>'; 
    print '<span class="opacitymedium">&nbsp;Choisissez un modèle pour calculer par défaut</span>';
    print '</td></tr>';

    print '<tr><td>Modules en série</td><td><input type="number" id="st_modules_series_0" name="st_modules_series" min="0" step="1" value="'.dol_escape_htmltag($editString['modules_in_series'] ?? '').'" oninput="igtPrefillString(0)"></td></tr>';
    print '<tr><td>Chaînes en parallèle</td><td><input type="number" id="st_strings_parallel_0" name="st_strings_parallel" min="1" step="1" value="'.dol_escape_htmltag($editString['strings_in_parallel'] ?? '1').'" oninput="igtPrefillString(0)"></td></tr>';
    print '<tr><td>Voc (V)</td><td><input type="text" id="st_voc_0" name="st_voc" size="10" value="'.dol_escape_htmltag($editString['voc_string_v'] ?? '').'"></td></tr>';
    print '<tr><td>Isc (A)</td><td><input type="text" id="st_isc_0" name="st_isc" size="10" value="'.dol_escape_htmltag($editString['isc_string_a'] ?? '').'"></td></tr>';
    print '<tr><td>Note</td><td><input type="text" name="st_note" size="60" value="'.dol_escape_htmltag($editString['note'] ?? '').'"></td></tr>';
    print '</table>';

    print '<br><input class="button button-save" type="submit" value="'.$langs->trans('Save').'"> ';
    if ($editString) print '<a class="button" href="'.$_SERVER['PHP_SELF'].'?socid='.$socid.'&contactid='.$contactid.'">Annuler</a>';
    print '</form>';
    print '</div>';

	$showBatForm = (!empty($editBattery) || $action === 'add_battery');
	print '<hr><div style="margin-bottom:10px;">';
	print '<a class="butAction" href="#" onclick="igtToggle(\'igt_form_bat\');return false;">'.($editBattery ? 'Modifier cette batterie' : 'Ajouter une batterie').'</a>';
	print '</div>';
	print '<div id="igt_form_bat" style="display:'.($showBatForm ? 'block' : 'none').';">';
	print '<h3>'.($editBattery ? 'Modification de la batterie' : 'Nouvelle batterie').'</h3>';
    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
    print '<input type="hidden" name="token" value="'.newToken().'">';
    print '<input type="hidden" name="socid" value="'.$socid.'">';
    print '<input type="hidden" name="contactid" value="'.$contactid.'">';
    if ($editBattery) {
        print '<input type="hidden" name="action" value="update_battery">';
        print '<input type="hidden" name="bat_id" value="'.(int)$editBattery['rowid'].'">';
    } else {
        print '<input type="hidden" name="action" value="save_battery">';
    }

    print '<table class="noborder centpercent">';
    print '<tr><td style="width:240px;">Identifiant (texte)</td><td><input type="text" name="bat_identifier" size="20" value="'.dol_escape_htmltag($editBattery['battery_identifier'] ?? '').'" placeholder="ex : BAT-1" required></td></tr>';
    print '<tr><td>Fabricant</td><td><input type="text" name="bat_manufacturer" size="30" value="'.dol_escape_htmltag($editBattery['manufacturer'] ?? '').'"></td></tr>';
    print '<tr><td>Référence</td><td><input type="text" name="bat_model" size="30" value="'.dol_escape_htmltag($editBattery['model'] ?? '').'"></td></tr>';
    print '<tr><td>Capacité (kWh)</td><td><input type="text" name="bat_capacity_kwh" size="10" value="'.dol_escape_htmltag($editBattery['capacity_kwh'] ?? '').'"></td></tr>';
    print '<tr><td>Tension (V)</td><td><input type="text" name="bat_voltage_v" size="10" value="'.dol_escape_htmltag($editBattery['voltage_v'] ?? '').'"></td></tr>';
    print '</table>';

    print '<br><input class="button button-save" type="submit" value="'.$langs->trans('Save').'"> ';
    if ($editBattery) print '<a class="button" href="'.$_SERVER['PHP_SELF'].'?socid='.$socid.'&contactid='.$contactid.'">Annuler</a>';
    print '</form>';
}

llxFooter();